﻿namespace Code6587EN.Ch02.GetDeviceChannelMaps
{
    using Microsoft.SharePoint;
    using System;
    using System.Collections;
    using System.Reflection;

    /// <summary>
    /// Console Application to get the Device Channel mappings for each
    /// Site in a Site Collection
    /// </summary>
    class Program
    {
        static void Main(string[] args)
        {
            // Get the Site Collection in a Using statement
            using (var site = new SPSite("http://sharepoint/sitecollection"))
            {
                // Get the Mappings File type and constructor
                var typeMappingFile = Type.GetType("Microsoft.SharePoint.Publishing.Mobile.MasterPageMappingsFile, Microsoft.SharePoint.Publishing, Version=15.0.0.0, Culture=neutral, PublicKeyToken=71e9bce111e9429c");                
                var consMappingFile = typeMappingFile.GetConstructor(new Type[] {typeof(SPWeb), typeof(bool), typeof(SPWeb)});

                // Iterate through each Site in the Site Collection
                foreach (SPWeb web in site.AllWebs)
                {
                    // Ensure the Site exists
                    if (web.Exists)
                    {
                        // Get the Mapping File for the Site
                        var mappingFile = consMappingFile.Invoke(new object[] { web, false, null });

                        // Output the Default channel details
                        Console.WriteLine("");
                        Console.WriteLine("Site: " + web.Url);
                        Console.WriteLine("Device Channel: Default");
                        Console.WriteLine("Master Page: " + web.CustomMasterUrl);

                        // Get the mappings field from the Mapping File and cast as the IDictionary interface
                        var mappings = (IDictionary)typeMappingFile.GetField("mappings", BindingFlags.Instance | BindingFlags.NonPublic).GetValue(mappingFile);

                        // Iterate through each key in the IDictionary
                        foreach (var key in mappings.Keys)
                        {
                            // Get the Master Page Url property from the mapping object
                            var mappingObject = mappings[key];
                            var masterUrl = (string)mappingObject.GetType().GetProperty("MasterPageUrl", BindingFlags.Instance | BindingFlags.Public).GetValue(mappingObject, null);
                            
                            // Output the Channel details
                            Console.WriteLine("");
                            Console.WriteLine("Site: " + web.Url);
                            Console.WriteLine("Device Channel: " + key);
                            Console.WriteLine("Master Page: " + masterUrl);
                        }

                        // Dispose the Site object
                        web.Dispose();
                    }
                }
            }

            // Wait for a key to be pressed before closing the application
            Console.WriteLine("Press Any Key to Continue...");
            Console.Read();
        }
    }
}
